“Volume” (`VOLM` in CSS) is an [axis](/glossary/axis_in_variable_fonts) found in some [variable fonts](/glossary/variable_fonts) that can be used to exaggerate details of a typeface in order to emphasize its personality.

The [Google Fonts CSS v2 API](https://developers.google.com/fonts/docs/css2) defines the axis as:

| Default: | Min: | Max: | Step: |
| --- | --- | --- | --- |
| 0 | 0 | 100 | 1 |

<figure>

![An image showing two type specimens, each with an axis slider underneath. The specimen on the left shows the effects of the axis’ lowest value. The specimen on the right shows the effects of the axis’ highest value.](images/thumbnail.svg)

<figcaption>The letter ‘h’ in the <a href="https://fonts.google.com/specimen/Commissioner">Commissioner</a> typeface is shown twice, once with a minimum value of the Volume axis applied, and again with the maximum value applied.</figcaption>
</figure>

Changes along the Volume axis expand the surface area or volume of the letterforms, and typically interact with the effects of other axes. For example, in the Commissioner typeface, the Volume axis exaggerates the effects of the [Flare (`FLAR`) axis](/glossary/flar_axis), which controls stroke modulation.

The number system of the axis is a percentage that starts from a neutral state at 0% and expands the volume to a maximum level of 100%.