When a [typographic change](/glossary/typography) is made to [text](/glossary/text_copy)—such as increasing the [font](/glossary/font) size, switching to a different [weight](/glossary/weight), or moving to an entirely new font—it’s likely the lines of [type](/glossary/type) will re-flow; that is, words that were set on one line prior to the change may then move to the line above or below.

In print, when a document has already been edited and designed, reflow can be problematic, such as text being cropped from the page when it no longer fits in its containing block.

<figure>

![Three text boxes of different widths. The second box is narrower than the first and therefore words have moved down to new lines. The third box is very narrow and the bottom line of text has disappeared outside of the frame.](images/thumbnail.svg)

</figure>

On the web and on screens in general, designers tend not to be strict about reflow, because they’re targeting a wide variety of viewports, and it’s the viewport that determines how many words appear per line. This can lead to problems; for instance, a long heading may take up multiple lines on a mobile device, causing the reader to scroll in order to see the body of the content.

Generally speaking, good typographic practice should allow for reflow and optimize the layout with responsive design methods.
