
A homoglyph is a [glyph](/glossary/glyph) with a design that can appear indistinguishable from—or least very similar to—another glyph with a separate meaning.

An uppercase I, lowercase l, and numeral 1 can appear near-identical in some typefaces, which presents a [legibility](/glossary/legibility) problem. If the wrong [character](/glossary/character) is used, it can confuse screen reading software and cause potential issues with searching and sorting. In some typefaces, there can be too subtle a distinction between different [dashes](/glossary/dashes) and the minus character.

<figure>

![Various examples of glyphs that appear to be homoglyphs in one typeface, then rendered again in another typeface that intentionally varies their design: Hyphens and minus symbols in one example; “Il1” characters in another. Also shown: An English-language sentence using the “H” character and a Greek-language sentence using the identical-but-semantically-different “Η” character.](images/thumbnail.svg)

</figure>

Homoglyphs also manifest themselves across different languages and/or scripts. An “H” glyph in English is not the same, semantically, as the look-alike “H” glyph (for the “eta” character) in [Greek](/glossary/greek_script), for instance. This isn’t a problem in print, but is an issue for any on-screen type, which is subject to being copied and pasted, and read aloud by screen reading software.

Max Halford has written more on this topic on [Homoglyphs: different characters that look identical](https://maxhalford.github.io/blog/homoglyphs/).
